/*
 * Decompiled with CFR 0.152.
 */
package com.minecolonies.coremod.compatibility;

import com.minecolonies.api.IMinecoloniesAPI;
import com.minecolonies.api.colony.IColonyManager;
import com.minecolonies.api.colony.buildings.modules.IBuildingModule;
import com.minecolonies.api.colony.buildings.modules.ICraftingBuildingModule;
import com.minecolonies.api.colony.buildings.registry.BuildingEntry;
import com.minecolonies.api.compatibility.ICompatibilityManager;
import com.minecolonies.api.crafting.IGenericRecipe;
import com.minecolonies.api.crafting.ItemStorage;
import com.minecolonies.api.crafting.ModCraftingTypes;
import com.minecolonies.api.crafting.registry.CraftingType;
import com.minecolonies.api.util.Log;
import com.minecolonies.coremod.colony.buildings.modules.SimpleCraftingModule;
import com.minecolonies.coremod.colony.crafting.CustomRecipeManager;
import com.minecolonies.coremod.colony.crafting.LootTableAnalyzer;
import com.minecolonies.coremod.colony.crafting.RecipeAnalyzer;
import java.io.BufferedWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.LevelResource;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CraftingTagAuditor {
    public static void doRecipeAudit(@NotNull MinecraftServer server, @NotNull CustomRecipeManager customRecipeManager) {
        CraftingTagAuditor.createFile("tag audit", server, "tag_audit.csv", writer -> CraftingTagAuditor.doTagAudit(writer, server));
        CraftingTagAuditor.createFile("recipe audit", server, "recipe_audit.csv", writer -> CraftingTagAuditor.doRecipeAudit(writer, server, customRecipeManager));
        CraftingTagAuditor.createFile("domum audit", server, "domum_audit.csv", writer -> CraftingTagAuditor.doDomumAudit(writer, server));
    }

    private static boolean createFile(@NotNull String description, @NotNull MinecraftServer server, @NotNull String filename, @NotNull Writeable generator) {
        Path outputPath = server.m_129843_(LevelResource.f_78182_).resolve("minecolonies").resolve(filename);
        Log.getLogger().info("Beginning " + description + "...");
        try {
            Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
            try (BufferedWriter writer = Files.newBufferedWriter(outputPath, new OpenOption[0]);){
                generator.write(writer);
            }
            Log.getLogger().info("Completed " + description + "; written to " + outputPath);
            return true;
        }
        catch (Exception ex) {
            Log.getLogger().error("Failed to write " + description + " to " + outputPath, (Throwable)ex);
            return false;
        }
    }

    private static List<ItemStack> getAllItems() {
        ICompatibilityManager compatibility = IColonyManager.getInstance().getCompatibilityManager();
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(compatibility.getListOfAllItems());
        items.sort(Comparator.comparing(stack -> stack.m_41720_().getRegistryName().toString()));
        return items;
    }

    private static void doTagAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        CraftingTagAuditor.writeItemHeaders(writer);
        writer.write(",tags...");
        writer.newLine();
        for (ItemStack item : CraftingTagAuditor.getAllItems()) {
            CraftingTagAuditor.writeItemData(writer, item);
            item.m_204131_().forEach(t -> {
                try {
                    writer.write(44);
                    writer.write(t.f_203868_().toString());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            });
            writer.newLine();
        }
    }

    private static void doRecipeAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server, @NotNull CustomRecipeManager customRecipeManager) throws IOException {
        Map<CraftingType, List<IGenericRecipe>> vanillaRecipesMap = RecipeAnalyzer.buildVanillaRecipesMap(server.m_129894_(), (Level)server.m_129783_());
        List crafters = CraftingTagAuditor.getCraftingModules().stream().sorted(Comparator.comparing(m -> m instanceof SimpleCraftingModule).reversed()).collect(Collectors.toList());
        HashMap<ItemStorage, Map<ICraftingBuildingModule, List<IGenericRecipe>>> craftingMap = new HashMap<ItemStorage, Map<ICraftingBuildingModule, List<IGenericRecipe>>>();
        for (List<IGenericRecipe> recipeList : vanillaRecipesMap.values()) {
            for (IGenericRecipe recipe : recipeList) {
                CraftingTagAuditor.add(customRecipeManager, craftingMap, null, recipe);
            }
        }
        CraftingTagAuditor.writeItemHeaders(writer);
        writer.write(",player");
        for (ICraftingBuildingModule crafter : crafters) {
            writer.write(44);
            writer.write(crafter.getCustomRecipeKey());
            List<IGenericRecipe> recipes = RecipeAnalyzer.findRecipes(vanillaRecipesMap, crafter);
            for (IGenericRecipe recipe : recipes) {
                CraftingTagAuditor.add(customRecipeManager, craftingMap, crafter, recipe);
            }
        }
        writer.newLine();
        for (ItemStack item : CraftingTagAuditor.getAllItems()) {
            CraftingTagAuditor.writeItemData(writer, item);
            Map<ICraftingBuildingModule, List<IGenericRecipe>> crafterMap = craftingMap.getOrDefault(new ItemStorage(item, true, false), Collections.emptyMap());
            CraftingTagAuditor.writeCrafterValue(writer, crafterMap, null);
            for (ICraftingBuildingModule crafter : crafters) {
                CraftingTagAuditor.writeCrafterValue(writer, crafterMap, crafter);
            }
            writer.newLine();
        }
    }

    private static void doDomumAudit(@NotNull BufferedWriter writer, @NotNull MinecraftServer server) throws IOException {
        ArrayList<IGenericRecipe> cutterRecipes = new ArrayList<IGenericRecipe>(ModCraftingTypes.ARCHITECTS_CUTTER.findRecipes(server.m_129894_(), (Level)server.m_129783_()));
        cutterRecipes.sort(Comparator.comparing(r -> r.getPrimaryOutput().m_41720_().getRegistryName().toString()));
        List crafters = CraftingTagAuditor.getCraftingModules().stream().filter(m -> m.canLearn(ModCraftingTypes.ARCHITECTS_CUTTER)).collect(Collectors.toList());
        writer.write("type,");
        CraftingTagAuditor.writeItemHeaders(writer);
        for (ICraftingBuildingModule crafter : crafters) {
            writer.write(44);
            writer.write(crafter.getCustomRecipeKey());
        }
        writer.newLine();
        for (IGenericRecipe recipe : cutterRecipes) {
            boolean first = true;
            List allSkins = recipe.getInputs().stream().flatMap(Collection::stream).map(ItemStorage::new).distinct().sorted(Comparator.comparing(s -> s.getItem().getRegistryName().toString())).map(ItemStorage::getItemStack).collect(Collectors.toList());
            for (ItemStack skin : allSkins) {
                if (first) {
                    CraftingTagAuditor.writeItemStack(writer, recipe.getPrimaryOutput());
                    first = false;
                }
                writer.write(44);
                CraftingTagAuditor.writeItemData(writer, skin);
                for (ICraftingBuildingModule crafter : crafters) {
                    writer.write(crafter.getIngredientValidator().test(skin).orElse(false) != false ? ",1" : ",");
                }
                writer.newLine();
            }
        }
    }

    private static void writeItemHeaders(@NotNull BufferedWriter writer) throws IOException {
        writer.write("item,name");
    }

    private static void writeItemData(@NotNull BufferedWriter writer, @NotNull ItemStack stack) throws IOException {
        CraftingTagAuditor.writeItemStack(writer, stack);
        writer.write(",\"");
        writer.write(stack.m_41611_().getString().replace("\"", "\"\""));
        writer.write(34);
    }

    private static void writeItemStack(@NotNull BufferedWriter writer, @NotNull ItemStack stack) throws IOException {
        writer.write(34);
        writer.write(stack.m_41720_().getRegistryName().toString());
        if (stack.m_41782_() && !stack.m_41763_()) {
            writer.write(stack.m_41783_().toString().replace("\"", "\"\""));
        }
        writer.write(34);
    }

    private static void writeCrafterValue(@NotNull BufferedWriter writer, @NotNull Map<ICraftingBuildingModule, List<IGenericRecipe>> crafterMap, @Nullable ICraftingBuildingModule crafter) throws IOException {
        writer.write(44);
        List recipeList = crafterMap.getOrDefault(crafter, Collections.emptyList());
        if (!recipeList.isEmpty()) {
            writer.write(Integer.toString(recipeList.size()));
        }
    }

    private static void add(@NotNull CustomRecipeManager customRecipeManager, @NotNull Map<ItemStorage, Map<ICraftingBuildingModule, List<IGenericRecipe>>> craftingMap, @Nullable ICraftingBuildingModule crafter, @NotNull IGenericRecipe recipe) {
        for (ItemStack stack : recipe.getAllMultiOutputs()) {
            CraftingTagAuditor.add(craftingMap, crafter, recipe, stack);
        }
        if (recipe.getLootTable() != null) {
            for (LootTableAnalyzer.LootDrop drop : customRecipeManager.getLootDrops(recipe.getLootTable())) {
                for (ItemStack stack : drop.getItemStacks()) {
                    CraftingTagAuditor.add(craftingMap, crafter, recipe, stack);
                }
            }
        }
    }

    private static void add(@NotNull Map<ItemStorage, Map<ICraftingBuildingModule, List<IGenericRecipe>>> craftingMap, @Nullable ICraftingBuildingModule crafter, @NotNull IGenericRecipe recipe, @NotNull ItemStack stack) {
        craftingMap.computeIfAbsent(new ItemStorage(stack, true, false), s -> new HashMap()).computeIfAbsent(crafter, c -> new ArrayList()).add(recipe);
    }

    private static List<ICraftingBuildingModule> getCraftingModules() {
        ArrayList<ICraftingBuildingModule> modules = new ArrayList<ICraftingBuildingModule>();
        for (BuildingEntry building : IMinecoloniesAPI.getInstance().getBuildingRegistry()) {
            for (Supplier<IBuildingModule> producer : building.getModuleProducers()) {
                IBuildingModule module = producer.get();
                if (!(module instanceof ICraftingBuildingModule)) continue;
                modules.add((ICraftingBuildingModule)module);
            }
        }
        return modules;
    }

    private CraftingTagAuditor() {
    }

    @FunctionalInterface
    private static interface Writeable {
        public void write(@NotNull BufferedWriter var1) throws IOException;
    }
}

